functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a =
	{
		"events": {
			"initGame": function () {
				// 游戏开始前的一些初始化操作

				// 根据flag来对道具进行修改
				if (core.flags.bigKeyIsBox)
					core.material.items.bigKey = { 'cls': 'items', 'name': '钥匙盒' };
				// 面前的墙？四周的墙？
				if (core.flags.pickaxeFourDirections)
					core.material.items.pickaxe.text = "可以破坏勇士四周的墙";
				if (core.flags.bombFourDirections)
					core.material.items.bomb.text = "可以炸掉勇士四周的怪物";
				if (core.flags.snowFourDirections)
					core.material.items.bomb.text = "可以将四周的熔岩变成平地";
				if (core.flags.equipment) {
					core.material.items.sword1.cls = 'constants';
					core.material.items.sword2.cls = 'constants';
					core.material.items.sword3.cls = 'constants';
					core.material.items.sword4.cls = 'constants';
					core.material.items.sword5.cls = 'constants';
					core.material.items.shield1.cls = 'constants';
					core.material.items.shield2.cls = 'constants';
					core.material.items.shield3.cls = 'constants';
					core.material.items.shield4.cls = 'constants';
					core.material.items.shield5.cls = 'constants';
				}
			},
			"setInitData": function (hard) {
				// 不同难度分别设置初始属性
				if (hard == 'Easy') { // 简单难度
					core.setFlag('hard', 1); // 可以用flag:hard来获得当前难度
					// 可以在此设置一些初始福利，比如设置初始生命值可以调用：
					// core.setStatus("hp", 10000);
					// 赠送一把黄钥匙可以调用
					// core.setItem("yellowKey", 1);
				}
				if (hard == 'Normal') { // 普通难度
					core.setFlag('hard', 2); // 可以用flag:hard来获得当前难度
				}
				if (hard == 'Hard') { // 困难难度
					core.setFlag('hard', 3); // 可以用flag:hard来获得当前难度
				}
				if (hard == 'Hell') { // 噩梦难度
					core.setFlag('hard', 4); // 可以用flag:hard来获得当前难度
				}
				core.events.afterLoadData();
			},
			"win": function (reason, norank) {
				// 游戏获胜事件 
				core.ui.closePanel();
				var replaying = core.status.replay.replaying;
				core.stopReplay();
				core.waitHeroToStop(function () {
					core.removeGlobalAnimate(0, 0, true);
					core.clearMap('all'); // 清空全地图
					core.drawText([
						"\t[" + (reason || "恭喜通关") + "]你的分数是${status:hp}。"
					], function () {
						core.events.gameOver(reason || '', replaying, norank);
					})
				});
			},
			"lose": function (reason) {
				// 游戏失败事件
				core.ui.closePanel();
				var replaying = core.status.replay.replaying;
				core.stopReplay();
				core.waitHeroToStop(function () {
					core.drawText([
						"\t[" + (reason || "结局1") + "]你死了。\n如题。"
					], function () {
						core.events.gameOver(null, replaying);
					});
				})
			},
			"afterChangeFloor": function (floorId) {
				// 转换楼层结束的事件
				if (!core.hasFlag("visited_" + floorId)) {
					core.insertAction(core.floors[floorId].firstArrive);
					core.setFlag("visited_" + floorId, true);
				}
				switch (core.getFlag("hard", 0)) {
					case 2: if (core.getFlag("youbiaoji") == 1) {
						core.canvas.animate.drawImage(core.material.images.images["biaoji.png"],
							core.getFlag("biaojix2"), core.getFlag("biaojiy2"));
					};
						break;
				}

			},
			"addPoint": function (enemy) {
				// 加点事件
				var point = enemy.point;
				if (!core.flags.enableAddPoint || !core.isset(point) || point <= 0) return [];

				// 加点，返回一个choices事件
				return [
					{
						"type": "choices",
						"choices": [
							{
								"text": "攻击+" + (1 * point), "action": [
									{ "type": "setValue", "name": "status:atk", "value": "status:atk+" + (1 * point) }
								]
							},
							{
								"text": "防御+" + (2 * point), "action": [
									{ "type": "setValue", "name": "status:def", "value": "status:def+" + (2 * point) }
								]
							},
							{
								"text": "生命+" + (200 * point), "action": [
									{ "type": "setValue", "name": "status:hp", "value": "status:hp+" + (200 * point) }
								]
							},
						]
					}
				];
			},
			"afterBattle": function (enemyId, x, y, callback) {
				// 战斗结束后触发的事件

				var enemy = core.material.enemys[enemyId];

				var damage = core.enemys.getDamage(enemyId);
				if (damage == null) damage = core.status.hero.hp + 1;

				// 扣减体力值
				core.status.hero.hp -= damage;

				// 记录
				core.status.hero.statistics.battleDamage += damage;

				if (core.status.hero.hp <= 0) {
					core.status.hero.hp = 0;
					core.updateStatusBar();
					core.events.lose('战斗失败');
					return;
				}
				//跳字
				var neirong = "HP-" + damage;
				core.plugin.tiaozishang(neirong);
				// 获得金币和经验
				var experience = enemy.experience;

				switch (core.getFlag("hard", 0)) {
					case 1: core.status.hero.experience = damage
						var hint = "打败 " + enemy.name;
						if (core.flags.enableExperience)
							hint += ",剑意变为" + core.status.hero.experience;
						break;
					case 4: if (core.hasItem('coin')) experience *= 2;
						core.status.hero.experience += experience;
						var hint = "打败 " + enemy.name + "金币+" + experience;
						break;
					default: var hint = "打败 " + enemy.name;
						break;
				}
				core.drawTip(hint);

				// 删除该块
				if (core.isset(x) && core.isset(y)) {
					core.removeBlock(x, y);
					core.canvas.event.clearRect(32 * x, 32 * y, 32, 32);
				}

				// 毒衰咒的处理
				var special = enemy.special;
				// 中毒
				if (core.enemys.hasSpecial(special, 12) && !core.hasFlag('poison')) {
					core.setFlag('poison', true);
				}
				// 衰弱
				if (core.enemys.hasSpecial(special, 13) && !core.hasFlag('weak')) {
					core.setFlag('weak', true);
					var weakValue = core.values.weakValue;
					var weakAtk = weakValue >= 1 ? weakValue : Math.floor(weakValue * core.status.hero.atk);
					var weakDef = weakValue >= 1 ? weakValue : Math.floor(weakValue * core.status.hero.def);
					core.setFlag('weakAtk', weakAtk);
					core.setFlag('weakDef', weakDef);
					core.status.hero.atk -= weakAtk;
					core.status.hero.def -= weakDef;
				}
				// 诅咒
				if (core.enemys.hasSpecial(special, 14) && !core.hasFlag('curse')) {
					core.setFlag('curse', true);
				}
				// 自爆
				if (core.enemys.hasSpecial(special, 19)) {
					core.status.hero.hp = 1;
				}
				// 退化
				if (core.enemys.hasSpecial(special, 21)) {
					core.status.hero.atk -= (enemy.atkValue || 0);
					core.status.hero.def -= (enemy.defValue || 0);
					if (core.status.hero.atk < 0) core.status.hero.atk = 0;
					if (core.status.hero.def < 0) core.status.hero.def = 0;
				}


				// 事件的处理
				var todo = [];
				// 如果不为阻击，且该点存在，且有事件
				if (!core.enemys.hasSpecial(special, 18) && core.isset(x) && core.isset(y)) {
					var event = core.floors[core.status.floorId].afterBattle[x + "," + y];
					if (core.isset(event)) {
						// 插入事件
						core.unshift(todo, event);
					}
				}

				// 如果有加点
				var point = core.material.enemys[enemyId].point;
				if (core.isset(point) && point > 0) {
					core.unshift(todo, core.events.addPoint(core.material.enemys[enemyId]));
				}

				switch (core.getFlag("hard", 0)) {
					case 1: core.unshift(todo, core.plugin.zhanhou());
						break;
					case 2: core.setFlag("zhenshang", 1);
						core.setFlag("kouchu", core.enemys.getDamage(enemyId));
						core.setFlag("zhenshang", 0);
						if (core.getFlag("minglingjishu") == 0) core.setFlag("minglingjishu", 21)
						else core.setFlag("minglingjishu", core.getFlag("minglingjishu") - 1)
						if (core.getFlag("kouchu") <= core.getFlag("jiangshang")) {
							core.setFlag("jiangshang", core.getFlag("jiangshang") - core.getFlag("kouchu"))
						}
						else {
							core.setFlag("jiangshang", 0)
						};
						if (core.getFlag("youbiaoji") == 1) {
							core.canvas.animate.drawImage(core.material.images.images["biaoji.png"],
								core.getFlag("biaojix2"), core.getFlag("biaojiy2"));
						};
						if (damage == 168 && damage >= 1) { core.setFlag("zuiai", 168); }
						if ((damage % 7 == 0 || damage.toString().indexOf('7') >= 0 || core.getFlag("zuiai") == 168) && damage >= 1) { core.unshift(todo, core.plugin.minglingzhanhou()) }
						else {
							core.status.hero.experience += 1;
							core.updateStatusBar();
						};
						break;
					case 3: core.plugin.maoguanzhanhou();
						break;

				}

				// 仇恨属性：减半
				if (core.flags.hatredDecrease && core.enemys.hasSpecial(special, 17)) {
					core.setFlag('hatred', parseInt(core.getFlag('hatred', 0) / 2));
				}
				// 增加仇恨值
				core.setFlag('hatred', core.getFlag('hatred', 0) + core.values.hatred);
				core.updateStatusBar();

				// 如果事件不为空，将其插入
				if (todo.length > 0) {
					core.events.insertAction(todo, x, y);
				}

				// 如果已有事件正在处理中
				if (core.status.event.id == null) {
					core.continueAutomaticRoute();
				}
				else {
					core.clearContinueAutomaticRoute();
				}
				if (core.isset(callback)) callback();

			},
			"afterOpenDoor": function (doorId, x, y, callback) {
				// 开一个门后触发的事件

				var todo = [];
				if (core.isset(x) && core.isset(y)) {
					var event = core.floors[core.status.floorId].afterOpenDoor[x + "," + y];
					if (core.isset(event)) {
						core.unshift(todo, event);
					}
				}

				if (todo.length > 0) {
					core.events.insertAction(todo, x, y);
				}

				if (core.status.event.id == null) {
					core.continueAutomaticRoute();
				}
				else {
					core.clearContinueAutomaticRoute();
				}
				if (core.isset(callback)) callback();
				switch (core.getFlag("hard", 0)) {
					case 1: ;
						break;
					case 2: ;
						break;
					case 3: core.status.hero.hp = core.status.hero.hp - (core.getFlag("cengshu") - 4) * 15;
						core.setFlag("maoguanshuici", core.getFlag("maoguanshuici") + 1);
				}

			},
			"afterChangeLight": function (x, y) {
				// 改变亮灯之后，可以触发的事件

			},
			"afterPushBox": function () {
				// 推箱子后的事件

				var noBoxLeft = function () {
					// 地图上是否还存在未推到的箱子，如果不存在则返回true，存在则返回false
					for (var i = 0; i < core.status.thisMap.blocks.length; i++) {
						var block = core.status.thisMap.blocks[i];
						if (core.isset(block.event) && block.event.id == 'box') return false;
					}
					return true;
				}

				if (noBoxLeft()) {
					// 可以通过if语句来进行开门操作
					/*
					if (core.status.floorId=='xxx') { // 在某个楼层
						core.insertAction([ // 插入一条事件
							{"type": "openDoor", "loc": [x,y]} // 开门
						])
					}
					*/
				}
			},
			"afterUseBomb": function () {
				// 使用炸弹/圣锤后的事件

				// 这是一个使用炸弹也能开门的例子
				/*
				if (core.status.floorId=='xxx' && core.terrainExists(x0,y0,'specialDoor') // 某个楼层，该机关门存在
					&& !core.enemyExists(x1,y1) && !core.enemyExists(x2,y2)) // 且守门的怪物都不存在
				{
					core.insertAction([ // 插入事件
						{"type": "openDoor", "loc": [x0,y0]} // 开门
					])
				}
				*/

			},
			"beforeSaveData": function (data) {
				// 即将存档前可以执行的操作

			},
			"afterLoadData": function (data) {
				// 读档事件后，载入事件前，可以执行的操作
				// 怪物数据的动态修改迁移到了“脚本编辑 - updateEnemys”中，详见文档说明

				core.enemys.updateEnemys();

			}
		},
		"enemys": {
			"getSpecials": function () {
				// 获得怪物的特殊属性，每一行定义一个特殊属性。
				// 分为三项，第一项为该特殊属性的数字，第二项为特殊属性的名字，第三项为特殊属性的描述
				// 可以直接写字符串，也可以写个function将怪物传进去
				return [
					[1, "先攻", "怪物首先攻击"],
					[2, "魔攻", "怪物无视勇士的防御"],
					[3, "坚固", "勇士每回合最多只能对怪物造成1点伤害"],
					[4, "2连击", "怪物每回合攻击2次"],
					[5, "3连击", "怪物每回合攻击3次"],
					[6, function (enemy) { return (enemy.n || 4) + "连击"; }, function (enemy) { return "怪物每回合攻击" + (enemy.n || 4) + "次"; }],
					[7, "破甲", "战斗前，怪物附加角色防御的" + Math.floor(100 * core.values.breakArmor || 0) + "%作为伤害"],
					[8, "反击", "战斗时，怪物每回合附加角色攻击的" + Math.floor(100 * core.values.counterAttack || 0) + "%作为伤害，无视角色防御"],
					[9, "净化", "战斗前，怪物附加勇士魔防的" + core.values.purify + "倍作为伤害"],
					[10, "模仿", "怪物的攻防和勇士攻防相等"],
					[11, "吸血", function (enemy) { return "吸血：战斗前，怪物首先吸取角色的" + Math.floor(100 * enemy.value || 0) + "%生命作为伤害" + (enemy.add ? "，并把伤害数值加到自身生命上" : ""); }],
					[12, "中毒", "战斗后，勇士陷入中毒状态，每一步损失生命" + core.values.poisonDamage + "点"],
					[13, "衰弱", "战斗后，勇士陷入衰弱状态，攻防暂时下降" + (core.values.weakValue >= 1 ? core.values.weakValue + "点" : parseInt(core.values.weakValue * 100) + "%")],
					[14, "诅咒", "战斗后，勇士陷入诅咒状态，战斗无法获得金币和经验"],
					[15, "领域", function (enemy) { return "经过怪物周围" + (enemy.range || 1) + "格时自动减生命" + (enemy.value || 0) + "点"; }],
					[16, "夹击", "经过两只相同的怪物中间，勇士生命值变成一半"],
					[17, "仇恨", "战斗前，怪物附加之前积累的仇恨值作为伤害" + (core.flags.hatredDecrease ? "；战斗后，释放一半的仇恨值" : "") + "。（每杀死一个怪物获得" + (core.values.hatred || 0) + "点仇恨值）"],
					[18, "阻击", function (enemy) { return "经过怪物的十字领域时自动减生命" + (enemy.value || 0) + "点，同时怪物后退一格"; }],
					[19, "自爆", "战斗后勇士的生命值变成1"],
					[20, "无敌", "勇士无法打败怪物，除非拥有十字架"],
					[21, "退化", function (enemy) { return "战斗后勇士永久下降" + (enemy.atkValue || 0) + "点攻击和" + (enemy.defValue || 0) + "点防御"; }],
					[22, "固伤", function (enemy) { return "战斗前，怪物对勇士造成" + (enemy.damage || 0) + "点固定伤害，无视勇士魔防。"; }],
					[23, "重生", "怪物被击败后，角色转换楼层则怪物将再次出现"],
					[24, "激光", "与怪物同处一行或一列时自动受到伤害"],
					[25, "连伤", "当前回合攻击所造成的伤害正比于当前攻击的次数"],
					[26, "boss", "这只boss面对某些角色的技能时候会获得一些特权"],
					[27, "大boss", "这只大boss面对某些角色的技能时候会获得一些特权"],
					[28, "寒冰", "当勇士装备剑时，对该种怪物攻击伤害*2"],
					[29, "流水", "当勇士装备剑时，对该种怪物攻击伤害/2,且该怪物每回合对勇士攻击伤害乘2"],
					[30, "侵蚀", "与该怪物战斗后降低1攻1防"],
				];
			},
			"getDamageInfo": function (enemy, hero_hp, hero_atk, hero_def, hero_mdef) {
				// 获得战斗伤害信息（实际伤害计算函数）

				// 怪物生命，怪物攻击、防御、特殊属性
				var mon_hp = enemy.hp, mon_atk = enemy.atk, mon_money = enemy.money, mon_def = enemy.def, mon_special = enemy.special;
				// 勇士的负属性都按0计算
				hero_hp = Math.max(0, hero_hp); hero_atk = Math.max(0, hero_atk); hero_def = Math.max(0, hero_def); hero_mdef = Math.max(0, hero_mdef);
				switch (core.getFlag("hard", 0)) {
					case 1: hero_atk += Math.floor(core.status.hero.experience / 20);

						break;
					case 3: if (this.hasSpecial(mon_special, 26) || this.hasSpecial(mon_special, 27)) {
						mon_atk = Math.ceil(mon_atk / core.getFlag("maoguanshuici") * 0.1)
						mon_def = Math.ceil(mon_def / core.getFlag("maoguanshuici") * 0.1)
						mon_hp = Math.ceil(mon_hp / core.getFlag("maoguanshuici") * 0.1);
					}
					else mon_atk = Math.ceil(mon_atk / core.getFlag("maoguanshuici") * 0.2)
						mon_def = Math.ceil(mon_def / core.getFlag("maoguanshuici") * 0.2)
						mon_hp = Math.ceil(mon_hp / core.getFlag("maoguanshuici") * 0.2);
						break;
					default: ;
						break;


				};

				// 如果是无敌属性，且勇士未持有十字架
				if (this.hasSpecial(mon_special, 20) && !core.hasItem("cross"))
					return null; // 不可战斗

				// 战前造成的额外伤害（可被魔防抵消）
				var init_damage = 0;

				// 吸血
				if (this.hasSpecial(mon_special, 11)) {
					var vampire_damage = hero_hp * enemy.value;

					// 如果有神圣盾免疫吸血等可以在这里写
					// if (core.hasFlag('shield5')) vampire_damage = 0;

					vampire_damage = Math.floor(vampire_damage) || 0;
					// 加到自身
					if (enemy.add) // 如果加到自身
						mon_hp += vampire_damage;

					init_damage += vampire_damage;
				}

				// 模仿
				if (this.hasSpecial(mon_special, 10)) {
					mon_atk = hero_atk;
					mon_def = hero_def;
				}
				// 坚固
				if (this.hasSpecial(mon_special, 3) && mon_def < hero_atk - 1)
					mon_def = hero_atk - 1;

				// 检查是否破防；否则直接返回不可战斗
				if (hero_atk <= mon_def) return null;

				// 每回合怪物对勇士造成的战斗伤害
				var per_damage = mon_atk - hero_def;
				// 魔攻：战斗伤害就是怪物攻击力
				if (this.hasSpecial(mon_special, 2)) per_damage = mon_atk;
				// 战斗伤害不能为负值
				if (per_damage < 0) per_damage = 0;

				// 2连击 & 3连击 & N连击
				if (this.hasSpecial(mon_special, 29)) per_damage *= 2;
				if (this.hasSpecial(mon_special, 4)) per_damage *= 2;
				if (this.hasSpecial(mon_special, 5)) per_damage *= 3;
				if (this.hasSpecial(mon_special, 6)) per_damage *= (enemy.n || 4);

				// 每回合的反击伤害；反击是按照勇士的攻击次数来计算回合
				var counterDamage = 0;
				// 速度
				if (core.status.hero.money < mon_money) {
					gongci = Math.floor(Math.log(mon_money / core.status.hero.money) + 1);
					switch (core.getFlag("hard", 0)) {
						case 1: if (core.getFlag('tingyong') == 0) gongci = 0

							break;
						default: ;
							break;

					};

				}
				if (core.status.hero.money > mon_money) gongci = -Math.floor(Math.log(core.status.hero.money / mon_money));
				if (core.status.hero.money == mon_money) {
					gongci = 1;
					switch (core.getFlag("hard", 0)) {
						case 1: if (core.getFlag('tingyong') == 0) gongci = 0

							break;
						default: ;
							break;

					};
				}

				if (this.hasSpecial(mon_special, 8)) counterDamage += Math.floor(core.values.counterAttack * hero_atk);

				// 先攻
				if (this.hasSpecial(mon_special, 1)) init_damage += per_damage;

				// 破甲
				if (this.hasSpecial(mon_special, 7))
					init_damage += Math.floor(core.values.breakArmor * hero_def);

				// 净化
				if (this.hasSpecial(mon_special, 9))
					init_damage += Math.floor(core.values.purify * hero_mdef);

				if (this.hasSpecial(mon_special, 28) && core.getFlag("jian") == 1) {
					var turn = Math.ceil(mon_hp / ((hero_atk - mon_def) * 2));
				}
				else {
					if (this.hasSpecial(mon_special, 29) && core.getFlag("jian") == 1) {
						var turn = Math.ceil(mon_hp / ((hero_atk - mon_def) / 2));
					}
					else {
						var turn = Math.ceil(mon_hp / (hero_atk - mon_def));
					}
				}
				turn += gongci;
				// 最终伤害：初始伤害 + 怪物对勇士造成的伤害 + 反击伤害
				var damage = init_damage + (turn - 1) * per_damage + turn * counterDamage;
				// 再扣去魔防
				if (this.hasSpecial(mon_special, 25)) {
					if (this.hasSpecial(mon_special, 4)) {
						turn = (turn - 1) * 2;
						turn += 1
					}
					if (this.hasSpecial(mon_special, 6)) {
						turn = (turn - 1) * (monster.n || 4);
						turn += 1
					}
					damage = damage * turn / 2;
				}

				damage -= hero_mdef;
				if (this.hasSpecial(mon_special, 17)) { damage += core.getFlag('hatred', 0); } // 仇恨

				switch (core.getFlag("hard", 0)) {
					case 1: damage = Math.floor(damage * 1.2);
						break;
					case 2: if (core.getFlag("minglingjishu") == 0) {
						damage = 168;
						if (this.hasSpecial(mon_special, 26)) damage = 1428;
						if (this.hasSpecial(mon_special, 27)) damage = 12138;
					};
						if (core.getFlag("zhenshang") == 1) { }
						else {
							if (damage <= core.getFlag("jiangshang", 0)) { damage = 0 }
							else {
								damage = damage - core.getFlag("jiangshang", 0);
							}
						}
						break;

				};

				// 检查是否允许负伤
				if (!core.flags.enableNegativeDamage)
					damage = Math.max(0, damage);

				return {
					"mon_hp": mon_hp,
					"mon_atk": mon_atk,
					"mon_def": mon_def,
					"init_damage": init_damage,
					"per_damage": per_damage,
					"turn": turn,
					"damage": damage,
					"mon_money": mon_money,

				};
			},
			"updateEnemys": function () {
				// 更新怪物数据，可以在这里对怪物属性和数据进行动态更新，详见文档——事件——怪物数据的动态修改
				// 比如下面这个例子，如果flag:xxx为真，则将绿头怪的攻击设为100，金币设为20
				/*
				if (core.hasFlag('xxx')) {
					core.material.enemys.greenSlime.atk = 100;
					core.material.enemys.greenSlime.money = 20;
				}
				*/
				// 别忘了在事件中调用“更新怪物数据”事件！
			}
		},
		"ui": {
			"drawAbout": function () {
				// 绘制“关于”界面
				if (!core.isPlaying()) {
					core.status.event = { 'id': null, 'data': null };
					core.dom.startPanel.style.display = 'none';
				}
				core.lockControl();
				core.status.event.id = 'about';

				core.clearMap('ui', 0, 0, 416, 416);
				var left = 48, top = 36, right = 416 - 2 * left, bottom = 416 - 2 * top;

				core.setAlpha('ui', 0.85);
				core.fillRect('ui', left, top, right, bottom, '#000000');
				core.setAlpha('ui', 1);
				core.strokeRect('ui', left - 1, top - 1, right + 1, bottom + 1, '#FFFFFF', 2);

				var text_start = left + 24;

				// 名称
				core.canvas.ui.textAlign = "left";
				core.fillText('ui', "战塔", text_start, top + 35, "#FFD700", "bold 22px Verdana");
				core.fillText('ui', "版本： " + core.firstData.version, text_start, top + 80, "#FFFFFF", "bold 17px Verdana");
				core.fillText('ui', "作者： 学习爱好者委员会（LAC）", text_start, top + 112);
				core.fillText('ui', '复刻者：见见', text_start, top + 112 + 32);
				core.fillText('ui', 'HTML5魔塔交流群：539113091', text_start, top + 112 + 32 + 32);
				// TODO: 写自己的“关于”页面，每次增加32像素即可
			}
		},
		"plugins": {
			"plugin": function () {
				////// 插件编写，可以在这里写自己额外需要执行的脚本 //////

				// 在这里写的代码，在所有模块加载完毕后，游戏开始前会被执行
				console.log("插件编写测试");
				// 可以写一些其他的被直接执行的代码


				// 在这里写所有需要自定义的函数
				// 写法必须是 this.xxx = function (args) { ...
				// 如果不写this的话，函数将无法被外部所访问
				this.test = function () {
					console.log("插件函数执行测试");
				}

				var _useEquipment = function (itemId, name, type) { // 具体的装备使用效果
					if (itemId.indexOf(name) == 0) {
						var now = core.getFlag(name, name + "0");

						if (typeof core.values[now] == 'number') {
							core.status.hero[type] -= core.values[now];
						}
						else {
							core.status.hero.atk -= core.values[now].atk || 0;
							core.status.hero.def -= core.values[now].def || 0;
							core.status.hero.mdef -= core.values[now].mdef || 0;
							core.status.hero.money -= core.values[now].money || 0;
						}

						if (typeof core.values[itemId] == 'number') {
							core.status.hero[type] += core.values[itemId];
						}
						else {
							core.status.hero.atk += core.values[itemId].atk || 0;
							core.status.hero.def += core.values[itemId].def || 0;
							core.status.hero.mdef += core.values[itemId].mdef || 0;
							core.status.hero.money += core.values[itemId].money || 0;
						}

						core.setItem(now, 1);
						core.setItem(itemId, 0);
						core.setFlag(name, itemId);
						if (itemId == "sword1") core.setFlag("jian", 1)
						if (itemId == "sword0") core.setFlag("jian", 0)
						core.drawTip("已装备" + core.material.items[itemId].name);
					}
				}

				this.useEquipment = function (itemId) { // 使用装备
					_useEquipment(itemId, "sword", "atk");

					_useEquipment(itemId, "shield", "def");
					_useEquipment(itemId, "ring", "mdef");
				}


				this.fenqi = function (fenqi) {//楼传(W)分歧
					switch (core.getFlag("hard", 0)) {
						case 1: core.plugin.tiaozhan();
							break;
						case 2: core.plugin.mingling2();
							break;
					}
				}
				this.shuomingfenqi = function (fenqi) {//说明书分歧
					core.setFlag("shuoming", 1)
					switch (core.getFlag("hard", 0)) {
						case 1: core.plugin.shuoming();
							break;
						case 2: core.plugin.shuomingmingling();
							break;
						case 3: core.plugin.shuomingmaoguan();
							break;
					}
				}
				this.Qjianfenqi = function (fenqi) {//Q键分歧
					core.setFlag("Qjineng", 1)
					switch (core.getFlag("hard", 0)) {
						case 2: core.plugin.mingling1();
							break;
					}
				}
				this.Ejianfenqi = function (fenqi) {//E键分歧
					core.setFlag("Ejineng", 1)
					switch (core.getFlag("hard", 0)) {
						case 2: core.plugin.mingling3();
							break;
					}
				}

				this.setHeroIcon = function (name) {//更换行走图


					core.setFlag("heroIcon", name);
					core.material.images.hero.src = core.material.images.images[name].src;
					core.material.icons.hero.height = core.material.images.images[name].height / 4;
					core.drawHero();

				}

				this.tiaozixue = function (neirong) {//跳字绿
					if (core.status.replay.replaying) { }
					else {
						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) { var tiaozizhong = 1 }
							};
							core.fillText('tiaozi', neirong, herox * 32 - 13, heroy * 32 + gaodu, "#00FF00", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);

					}
				}

				this.tiaozishang = function (neirong) {//跳字红
					if (core.status.replay.replaying) { }
					else {

						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) { var tiaozizhong = 1 }
							};
							core.fillText('tiaozi', neirong, herox * 32 - 13, heroy * 32 + gaodu, "#FF0000", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);

					}
				}

				this.tiaozilan = function (neirong) {//跳字蓝
					if (core.status.replay.replaying) { }
					else {

						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) { var tiaozizhong = 1 }
							};
							core.fillText('tiaozi', neirong, herox * 32 - 13, heroy * 32 + gaodu, "#5CACEE", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);

					}
				}
				this.tiaozihei = function (neirong) {//跳字黑
					if (core.status.replay.replaying) { }
					else {

						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) { var tiaozizhong = 1 }
							};
							core.fillText('tiaozi', neirong, herox * 32 - 13, heroy * 32 + gaodu, "#0F0F0F", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);

					}
				}
				this.tiaozi = function (neirong) {//跳字白
					if (core.status.replay.replaying) { }
					else {
						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) { var tiaozizhong = 1 }
							};
							core.fillText('tiaozi', neirong, herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);
					}
				}
				this.tiaozi2 = function (neirong1, neirong2) {//二段跳字
					if (core.status.replay.replaying) { }
					else {
						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var huanzi = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) {
									if (huanzi == 1) { var tiaozizhong = 1 }
									else {
										huanzi = 1; gaodu = 0; shangsheng = 1;
									}
								}
							};
							if (huanzi == 0) core.fillText('tiaozi', neirong1, herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
							else core.fillText('tiaozi', neirong2, herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);
					}
				}
				this.tiaozi3 = function (neirong1, neirong2, neirong3, yanse1, yanse2, yanse3) {//三段跳字
					if (core.status.replay.replaying) { }
					else {
						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var huanzi = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) {
									switch (huanzi) {
										case 0: {
											huanzi = 1;
											gaodu = 0;
											shangsheng = 1;
										};
											break;
										case 1: {
											huanzi = 2;
											gaodu = 0;
											shangsheng = 1;
										};
											break;
										case 2: var tiaozizhong = 1;
											break;
									}
								}
							}
							switch (huanzi) {
								case 0: core.fillText('tiaozi', neirong1, herox * 32 - 13, heroy * 32 + gaodu, yanse1, "bold 17px Verdana");
									break;
								case 1: core.fillText('tiaozi', neirong2, herox * 32 - 13, heroy * 32 + gaodu, yanse2, "bold 17px Verdana");
									break;
								case 2: core.fillText('tiaozi', neirong3, herox * 32 - 13, heroy * 32 + gaodu, yanse3, "bold 17px Verdana");
									break;
							}
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);
					}
				}

				this.meicengguoguan = function (guoguan) {//每层过关执行的内容
					core.setFlag("youbiaoji", 0);
					core.insertAction([{ "type": "showImage" },])
				}
				this.xingzou = function (xingzou) {//见见血溅三步行走
					if (core.getFlag("tingyong") == 2) { }
					else {
						if (core.getFlag("tingyong") == 1) {
							core.status.hero.experience = core.getFlag("jianyi");
							core.setFlag("tingyong", 2);
							core.plugin.setHeroIcon('hero.png');
							core.updateStatusBar()
						}
						else {
							core.setFlag("linshi2", core.status.hero.steps);
							core.setFlag("linshi1", core.getFlag("linshi2") - core.getFlag("jilu"));
							if (core.getFlag("linshi1") <= 3) {
								core.status.hero.experience += core.getFlag("cengshu");
								core.updateStatusBar()

							}
							else {
								core.setFlag("tingyong", 2);
								core.status.hero.experience = core.getFlag("jianyi");
								core.plugin.setHeroIcon('hero.png');
								core.updateStatusBar()
							}
						}
					}
				}
				this.maoguanzhanhou = function (zhanhou) {//冒灌战后（雷击）
					core.insertAction(
						[
							{ "type": "setValue", "name": "flag:herox", "value": "core.status.hero.loc.x" },
							{ "type": "setValue", "name": "flag:heroy", "value": "core.status.hero.loc.y" },
							{ "type": "function", "function": "function(){\nif (core.status.hero.loc.direction == 'up') core.setFlag('heroz',1);     else if (core.status.hero.loc.direction == 'right') core.setFlag('heroz',2);     else if (core.status.hero.loc.direction == 'down') core.setFlag('heroz',3);     else if (core.status.hero.loc.direction == 'left') core.setFlag('heroz',4);\n}" },
							{ "type": "function", "function": "function(){\nswitch (core.getFlag(\"heroz\")) {     case 1: core.setFlag(\"heroy\",core.getFlag(\"heroy\")-2); break;     case 2: core.setFlag(\"herox\",core.getFlag(\"herox\")+2); break;case 3: core.setFlag(\"heroy\",core.getFlag(\"heroy\")+2); break;case 4: core.setFlag(\"herox\",core.getFlag(\"herox\")-2); break; }\n}" },
							{ "type": "function", "function": "function(){\nswitch (core.getFlag(\"cengshu\")) {     \n\tcase 5:if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=10 && core.getFlag(\"heroy\")<=11 && core.getFlag(\"herox\")>=2 && core.getFlag(\"heroy\")>=3){}\n\t\telse core.setFlag(\"kepi\",0)\n\t\t; break;\n\tcase 6: if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=10 && core.getFlag(\"heroy\")<=11 && core.getFlag(\"herox\")>=2 && core.getFlag(\"heroy\")>=3){}\n\t\telse core.setFlag(\"kepi\",0)\n\t\t; break;\n\tcase 7:if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=10 && core.getFlag(\"heroy\")<=11 && core.getFlag(\"herox\")>=2 && core.getFlag(\"heroy\")>=3){}\n\t\telse core.setFlag(\"kepi\",0)\n\t\t; break;\n\tcase 8:if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=11 && core.getFlag(\"heroy\")<=12 && core.getFlag(\"herox\")>=1 && core.getFlag(\"heroy\")>=2){}\n\t\telse core.setFlag(\"kepi\",0)\n\t\t; break; \n\tcase 9: if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=11 && core.getFlag(\"heroy\")<=12 && core.getFlag(\"herox\")>=1 && core.getFlag(\"heroy\")>=2){}\n\t\telse core.setFlag(\"kepi\",0); break;\n\tcase 10: if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=11 && core.getFlag(\"heroy\")<=12 && core.getFlag(\"herox\")>=1 && core.getFlag(\"heroy\")>=2){}\n\t\telse core.setFlag(\"kepi\",0); break;\n\tcase 11:if(core.getFlag(\"herox\")==6){}\n\telse if(core.getFlag(\"herox\")<=11 && core.getFlag(\"heroy\")<=11 && core.getFlag(\"herox\")>=1 && core.getFlag(\"heroy\")>=1){}\n\t\telse core.setFlag(\"kepi\",0) ; break;\n\t }\n}" },
							{ "type": "function", "function": "function(){\nif(core.getBlockId(core.getFlag(\"herox\"), core.getFlag(\"heroy\"))==null){}\nelse core.setFlag(\"kepi\",0)\n}" },
							{
								"type": "if", "condition": "flag:kepi==0",
								"true": [

								],
								"false": [
									{ "type": "function", "function": "function(){\ncore.insertAction([{\"type\": \"animate\", \"name\": \"maoguanlei\", \"loc\": [core.getFlag(\"herox\"),core.getFlag(\"heroy\")]},])\n}" },
									{ "type": "setValue", "name": "status:experience", "value": "status:experience+5" },
									{ "type": "hide", "loc": ["flag:herox", "flag:heroy"], "time": 500 },
								]
							},
						]

					)

				}
				this.zhanhou = function (zhanhou) {//见见战后
					return [
						{ "type": "update" },
						{ "type": "setValue", "name": "flag:jianyi", "value": "status:experience" },
						{ "type": "setValue", "name": "flag:jilu", "value": "core.status.hero.steps" },
						{ "type": "setHeroIcon", "name": "hero2.png" },
						{ "type": "animate", "name": "xuejiansanbu", "loc": "hero" },
						{ "type": "setValue", "name": "flag:tingyong", "value": "0" },
					]
				}


				this.minglingzhanhou = function (minglingzhanhou) {//冥灵战后
					return [
						{
							"type": "if", "condition": "flag:zuiai==168",
							"true": [
								"168！！！！",
								"这是我最爱最爱的168！！！",
								{ "type": "setValue", "name": "status:experience", "value": "status:experience+21" },
								{ "type": "function", "function": "function(){\ncore.setFlag(\"biaojix\",core.nextX())\n}" },
								{ "type": "function", "function": "function(){\ncore.setFlag(\"biaojiy\",core.nextY())\n}" },
								{ "type": "setValue", "name": "flag:youbiaoji", "value": "1" },
								{ "type": "setValue", "name": "flag:biaojix2", "value": "flag:biaojix*32" },
								{ "type": "setValue", "name": "flag:biaojiy2", "value": "flag:biaojiy*32" },
								{ "type": "setValue", "name": "flag:zuiai", "value": "0" },
								{ "type": "showImage" },
								{ "type": "showImage", "name": "biaoji.png", "loc": ["flag:biaojix2", "flag:biaojiy2"] },
							],
							"false": [
								"这伤害我喜欢",
								{
									"type": "choices", "text": "这伤害我喜欢，请选择", "choices": [
										{
											"text": "我要标记这个敌人", "action": [
												{ "type": "function", "function": "function(){\ncore.setFlag(\"biaojix\",core.nextX())\n}" },
												{ "type": "function", "function": "function(){\ncore.setFlag(\"biaojiy\",core.nextY())\n}" },
												{ "type": "setValue", "name": "flag:biaojix2", "value": "flag:biaojix*32" },
												{ "type": "setValue", "name": "flag:biaojiy2", "value": "flag:biaojiy*32" },
												{ "type": "setValue", "name": "flag:youbiaoji", "value": "1" },
												{ "type": "showImage" },
												{ "type": "showImage", "name": "biaoji.png", "loc": ["flag:biaojix2", "flag:biaojiy2"] },
											]
										},
										{
											"text": "我要七点能量", "action": [
												{ "type": "setValue", "name": "status:experience", "value": "status:experience+7" },
											]
										},
									]
								},
							]
						},
					]

				}
				this.shumaqianyao = function (mingling1) {//冥灵1技能数码护盾前摇（跳字）
					if (core.status.replay.replaying) { }
					else {
						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var huanzi = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) {
									if (huanzi == 1) { var tiaozizhong = 1 }
									else {
										huanzi = 1; gaodu = 0; shangsheng = 1;
									}
								}
							};
							if (huanzi == 0) core.fillText('tiaozi', "护盾+3", herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
							else core.fillText('tiaozi', "能量-1", herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);
					}
				}
				this.mingling1 = function (mingling1) {//冥灵1技能数码护盾
					if (core.getFlag("hard") == 2) {
						core.setFlag("louchuan", 1);
						core.insertAction([
							{
								"type": "if", "condition": "status:experience>=1",
								"true": [
									{ "type": "setValue", "name": "flag:jiangshang", "value": "flag:jiangshang+3" },
									{ "type": "setValue", "name": "status:experience", "value": "status:experience-1" },
									{ "type": "function", "function": "function(){\ncore.plugin.shumaqianyao();\n}" },],
								"false": [
									{ "type": "function", "function": "function(){\nswitch (core.rand2(5)) {     case 0: core.insertAction(\"能量枯竭，无法启动护盾\"); break;     case 1: core.insertAction(\"警告，能源不足，警告，能源不足\"); break;case 2: core.insertAction(\"数码护盾服务部提示您，您的能量余额已不足，请充值\"); break;case 3: core.insertAction(\"我觉得我需要一个充电宝\"); break;case 4: core.insertAction(\"我的充电宝呢？我的充能棒呢？\"); break; }\n}" },
								]
							},
							{ "type": "exit" },
						]
						)
					};
				}

				this.mingling2 = function (mingling2) {//冥灵2技能
					core.setFlag("louchuan", 1);
					core.insertAction([
						{ "type": "setValue", "name": "flag:luodian", "value": "0" },
						{ "type": "setValue", "name": "flag:hao", "value": "0" },
						{
							"type": "if", "condition": "flag:youbiaoji==1",
							"true": [
								{ "type": "setValue", "name": "flag:herox", "value": "core.status.hero.loc.x" },
								{ "type": "setValue", "name": "flag:heroy", "value": "core.status.hero.loc.y" },
								{
									"type": "if", "condition": "flag:herox>=flag:biaojix",
									"true": [
										{ "type": "setValue", "name": "flag:hero2x", "value": "(flag:herox-flag:biaojix)" },
										{ "type": "setValue", "name": "flag:hero3x", "value": "(flag:biaojix-flag:hero2x)" },
									],
									"false": [
										{ "type": "setValue", "name": "flag:hero2x", "value": "(flag:biaojix-flag:herox)" },
										{ "type": "setValue", "name": "flag:hero3x", "value": "(flag:biaojix+flag:hero2x)" },
									]
								},
								{
									"type": "if", "condition": "flag:heroy>=flag:biaojiy",
									"true": [
										{ "type": "setValue", "name": "flag:hero2y", "value": "(flag:heroy-flag:biaojiy)" },
										{ "type": "setValue", "name": "flag:hero3y", "value": "(flag:biaojiy-flag:hero2y)" },
									],
									"false": [
										{ "type": "setValue", "name": "flag:hero2y", "value": "(flag:biaojiy-flag:heroy)" },
										{ "type": "setValue", "name": "flag:hero3y", "value": "(flag:biaojiy+flag:hero2y)" },
									]
								},
								{ "type": "function", "function": "function(){\nif(core.getBlockId(core.getFlag(\"hero3x\"), core.getFlag(\"hero3y\"))==null)core.setFlag(\"luodian\",1)\n}" },
								{
									"type": "if", "condition": "flag:luodian==1",
									"true": [
										{ "type": "function", "function": "function(){\nif(core.getFlag(\"hero3x\")<=12 && core.getFlag(\"hero3y\")<=12 && core.getFlag(\"hero3x\")>=0 && core.getFlag(\"hero3y\")>=0){}\n\telse {core.setFlag(\"luodian\",0)}\n}" },
										{
											"type": "if", "condition": "flag:luodian==1",
											"true": [
												{ "type": "function", "function": "function(){\nvar fillstyle = \"rgba(0,255,0,0.5)\";\ncore.fillRect(\"weather\",core.getFlag(\"hero3x\")*32,core.getFlag(\"hero3y\")*32,32,32,fillstyle);\n}" },
											],
											"false": [

											]
										},
									],
									"false": [
										{ "type": "function", "function": "function(){\nvar fillstyle = 'rgba(255,0,0,0.5)';\ncore.fillRect('weather',core.getFlag(\"hero3x\")*32,core.getFlag(\"hero3y\")*32,32,32,fillstyle);\n}" },
									]
								},
								{ "type": "tip", "text": "请确认当前零式飞行的目标位置" },
								{ "type": "wait" },
								{
									"type": "if", "condition": "flag:type==0",
									"true": [
										{
											"type": "if", "condition": "flag:keycode==13",
											"true": [
												{ "type": "setValue", "name": "flag:hao", "value": "1" },
											],
											"false": [

											]
										},
										{
											"type": "if", "condition": "flag:keycode==87",
											"true": [
												{ "type": "setValue", "name": "flag:hao", "value": "1" },
											],
											"false": [

											]
										},
										{
											"type": "if", "condition": "flag:keycode==32",
											"true": [
												{ "type": "setValue", "name": "flag:hao", "value": "1" },
											],
											"false": [

											]
										},
									],
									"false": [
										{
											"type": "if", "condition": "flag:x==flag:hero3x && flag:y==flag:hero3y",
											"true": [
												{ "type": "setValue", "name": "flag:hao", "value": "1" },
											],
											"false": [

											]
										},
									]
								},
								{ "type": "function", "function": "function(){\ncore.clearMap(\"weather\")\n}" },
								{
									"type": "if", "condition": "flag:hao==1",
									"true": [
										{
											"type": "if", "condition": "flag:luodian==1",
											"true": [
												{ "type": "animate", "name": "lingshifeixing", "loc": "hero" },
												{ "type": "setValue", "name": "flag:luodian", "value": "0" },
												{ "type": "changePos", "loc": ["flag:hero3x", "flag:hero3y"] },
												{ "type": "animate", "name": "minglingfei", "loc": "hero" },
												{
													"type": "if", "condition": "status:experience>=5",
													"true": [
														{
															"type": "choices", "text": "欢迎乘坐MH168航班，请问您是否要使用5能量保留标记？", "choices": [
																{
																	"text": "是", "action": [
																		{ "type": "setValue", "name": "status:experience", "value": "(status:experience-5)" },
																		{ "type": "function", "function": "function(){\nvar neirong=\"能量-5\";core.plugin.tiaozi(neirong);\n}" },
																	]
																},
																{
																	"text": "否", "action": [
																		{ "type": "showImage" },
																		{ "type": "setValue", "name": "flag:huoneng", "value": "flag:hero2x+flag:hero2y" },
																		{ "type": "setValue", "name": "status:experience", "value": "(status:experience+flag:huoneng)" },
																		{ "type": "function", "function": "function(){\nvar neirong=\"能量+\"+core.getFlag(\"huoneng\",0);core.plugin.tiaozi(neirong);\n}" },
																		{ "type": "setValue", "name": "flag:biaojix", "value": "0" },
																		{ "type": "setValue", "name": "flag:biaojiy", "value": "0" },
																		{ "type": "setValue", "name": "flag:youbiaoji", "value": "0" },
																	]
																},
															]
														},
													],
													"false": [
														{ "type": "showImage" },
														{ "type": "setValue", "name": "flag:huoneng", "value": "flag:hero2x+flag:hero2y" },
														{ "type": "setValue", "name": "status:experience", "value": "(status:experience+flag:huoneng)" },
														{ "type": "setValue", "name": "flag:biaojix", "value": "0" },
														{ "type": "setValue", "name": "flag:biaojiy", "value": "0" },
														{ "type": "setValue", "name": "flag:youbiaoji", "value": "0" },
														{ "type": "function", "function": "function(){\nvar neirong=\"能量+\"+core.getFlag(\"huoneng\",0);core.plugin.tiaozi(neirong);\n}" },
													]
												},
												{
													"type": "if", "condition": "flag:jiaoxueceng==1",
													"true": [
														{
															"type": "if", "condition": "core.status.hero.loc.x>=7",
															"true": [
																"恭喜你成功地飞到了右边~绕出了三只石头的重围！",
																"这就是零式飞行的一般使用方法，也就是使自己移动到有利的地方",
																"此外，通关本教学层的方法，就是把蝙蝠打了，变成标记，然后飞出教学层",
																"去试试吧",
																{ "type": "setValue", "name": "flag:jiaoxueceng", "value": "0" },
															],
															"false": [
																"哦，好吧，看来你没有成功飞出三只石头的重围",
																"没关系，让我们重新再来一遍，这一次一定要飞出去哦~",
															]
														},
													],
													"false": [

													]
												},
											],
											"false": [
												{ "type": "tip", "text": "当前不能使用零式飞行" },
											]
										},
									],
									"false": [

									]
								},
							],
							"false": [
								{ "type": "function", "function": "function(){\nswitch (core.rand2(5)) {     case 0: core.insertAction(\"MH168航班服务组提示您，我们航班的导航系统坏了\"); break;     case 1: core.insertAction(\"零式飞行启动，目标地点.....目标地点在哪\"); break;case 2: core.insertAction(\"给我一个标记，我能飞到世界的尽头\"); break;case 3: core.insertAction(\"空间传送装置缺少关键空间节点标记，无法启动\"); break;case 4: core.insertAction(\"大声告诉我场上的标记在哪里！\"); break; }\n}" },
							]
						},
						{ "type": "exit" },
					]

					)
				}

				this.piliangqianyao = function (huanzi) {//冥灵3技能批量用能前摇（跳字）
					if (core.status.replay.replaying) { }
					else {
						core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) + 1);
						var shangsheng = 1;
						var gaodu = 0;
						var herox = core.status.hero.loc.x, heroy = core.status.hero.loc.y;
						var fade = setInterval(function () {
							core.clearMap('tiaozi', 0, 0, 416, 416);
							if (gaodu >= -6 && shangsheng == 1) {
								gaodu = gaodu - 1;
								if (gaodu == -6) { shangsheng = 0 }
							}
							else if (gaodu <= 12) {
								gaodu = gaodu + 1;
								if (gaodu == 12) {
									switch (huanzi) {
										case 0: {
											huanzi = 1;
											gaodu = 0;
											shangsheng = 1;
										};
											break;
										case 1: var tiaozizhong = 1;
											break;
										case 2: {
											huanzi = 3;
											gaodu = 0;
											shangsheng = 1;
										};
											break;
										case 3: var tiaozizhong = 1;
											break;
									}

								};
							}
							switch (huanzi) {
								case 0: core.fillText('tiaozi', "护盾+" + 3 * core.getFlag("input"), herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
									break;
								case 1: core.fillText('tiaozi', "能量-" + core.getFlag("input"), herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
									break;
								case 2: core.fillText('tiaozi', "护盾-" + 3 * core.getFlag("input"), herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
									break;
								case 3: core.fillText('tiaozi', "能量+" + core.getFlag("input"), herox * 32 - 13, heroy * 32 + gaodu, "#FFFFFF", "bold 17px Verdana");
									break;
							}
							if (tiaozizhong == 1 || core.getFlag("tiaozizhong") >= 2) {
								core.setFlag("tiaozizhong", core.getFlag("tiaozizhong", 0) - 1);
								core.clearMap('tiaozi', 0, 0, 416, 416);
								clearInterval(fade);
							}
						}, 16);
					}
				}

				this.mingling3 = function (mingling3) {//冥灵3技能
					core.setFlag("louchuan", 1);
					core.insertAction([
						{
							"type": "choices", "text": "欢迎来到快捷支付和退款界面，您想要：", "choices": [
								{
									"text": "批量使用能量", "action": [
										{ "type": "input", "text": "你需要使用多少能量" },
										{
											"type": "if", "condition": "status:experience>=flag:input",
											"true": [
												{ "type": "setValue", "name": "flag:jiangshang", "value": "flag:jiangshang+3*flag:input" },
												{ "type": "setValue", "name": "status:experience", "value": "status:experience-flag:input" },
												{ "type": "function", "function": "function(){\nvar huanzi=0;\ncore.plugin.piliangqianyao(huanzi);\n}" },
											],
											"false": [
												{ "type": "function", "function": "function(){\nswitch (core.rand2(5)) {     case 0: core.insertAction(\"能量枯竭，无法启动护盾\"); break;     case 1: core.insertAction(\"警告，能源不足，警告，能源不足\"); break;case 2: core.insertAction(\"数码护盾服务部提示您，您的能量余额已不足，请充值\"); break;case 3: core.insertAction(\"我觉得我需要一个充电宝\"); break;case 4: core.insertAction(\"我的充电宝呢？我的充能棒呢？\"); break; }\n}" },
											]
										},
									]
								},
								{
									"text": "批量回退能量", "action": [
										{ "type": "input", "text": "你需要回退多少能量" },
										{
											"type": "if", "condition": "flag:jiangshang>=flag:input*3",
											"true": [
												{ "type": "setValue", "name": "flag:jiangshang", "value": "flag:jiangshang-3*flag:input" },
												{ "type": "setValue", "name": "status:experience", "value": "status:experience+flag:input" },
												{ "type": "function", "function": "function(){\nvar huanzi=2;\ncore.plugin.piliangqianyao(huanzi);\n}" },
											],
											"false": [
												{ "type": "function", "function": "function(){\nswitch (core.rand2(5)) {     case 0: core.insertAction(\"护盾能量已耗尽，无法提取\"); break;     case 1: core.insertAction(\"警告，护盾能量已不足\"); break;case 2: core.insertAction(\"数码护盾服务部提示您，我们给你退钱已经很亲民了，别得寸进尺哈\"); break;case 3: core.insertAction(\"这个充电宝已经没电了\"); break;case 4: core.insertAction(\"这个护盾已经被抽干了\"); break; }\n}" },
											]
										},
									]
								},
							]
						},
						{ "type": "exit" },
					])
				}

				this.tiaozhan = function (tiaozhan) {//见见跳斩
					core.insertAction([
						{ "type": "function", "function": "function(){\ncore.setFlag('suiji',core.rand(4)+1)\n}" },
						{ "type": "setValue", "name": "flag:louchuan", "value": "1" },
						{
							"type": "if", "condition": "status:experience>=30",
							"true": [
								{ "type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x,core.status.hero.loc.y+core.getFlag('linshi1',100))) {core.setFlag('linshi2',1);}\n}" },
								{ "type": "setValue", "name": "flag:herox", "value": "core.status.hero.loc.x" },
								{ "type": "setValue", "name": "flag:heroy", "value": "core.status.hero.loc.y" },
								{ "type": "setValue", "name": "flag:herotux", "value": "(flag:herox*32)" },
								{ "type": "setValue", "name": "flag:herotuy", "value": "(flag:heroy*32)" },
								{ "type": "setValue", "name": "flag:linshi1", "value": "1" },
								{ "type": "setValue", "name": "flag:linshi2", "value": "0" },
								{ "type": "function", "function": "function(){\nif (core.status.hero.loc.direction == 'up') core.setFlag('heroz',1);     else if (core.status.hero.loc.direction == 'right') core.setFlag('heroz',2);     else if (core.status.hero.loc.direction == 'down') core.setFlag('heroz',3);     else if (core.status.hero.loc.direction == 'left') core.setFlag('heroz',4);\n}" },
								{
									"type": "if", "condition": "flag:heroz==1",
									"true": [
										{ "type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)" },
										{ "type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)" },
										{ "type": "setValue", "name": "flag:panduan", "value": "flag:herotuy" },
										{ "type": "setValue", "name": "flag:herotuy", "value": "(flag:herotuy-32)" },
										{ "type": "animateImage", "action": "show", "name": "shang.png", "loc": ["flag:herodatux", "flag:herodatuy"], "time": 500 },
										{ "type": "showImage", "name": "shang.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
										{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy"] },
										{
											"type": "while", "condition": "true",
											"data": [
												{ "type": "wait" },
												{
													"type": "if", "condition": "flag:type==0",
													"true": [
														{
															"type": "if", "condition": "flag:keycode==27",
															"true": [
																{ "type": "showImage" },
																{ "type": "exit" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==13",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==32",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==38",
															"true": [
																{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy-32)" },
																{ "type": "showImage" },
																{ "type": "showImage", "name": "shang.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux", "flag:herotuy2"], "time": 1 },
																{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy2"] },
																{ "type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2" },
																{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==40",
															"true": [
																{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy+32)" },
																{
																	"type": "if", "condition": "flag:herotuy2>=flag:panduan",
																	"true": [
																		{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy-32)" },
																	],
																	"false": [
																		{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)" },
																		{ "type": "showImage" },
																		{ "type": "showImage", "name": "shang.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																		{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux", "flag:herotuy2"], "time": 1 },
																		{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy2"] },
																		{ "type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2" },
																	]
																},
															],
															"false": [

															]
														},
													],
													"false": [
														{
															"type": "if", "condition": "flag:x==flag:herox",
															"true": [
																{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:y*32)" },
																{
																	"type": "if", "condition": "flag:herotuy2>=flag:panduan",
																	"true": [

																	],
																	"false": [
																		{
																			"type": "if", "condition": "flag:herotuy2==flag:herotuy",
																			"true": [
																				{ "type": "break" },
																			],
																			"false": [
																				{ "type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.status.hero.loc.y-core.getFlag(\"y\"))\n}" },
																				{ "type": "showImage" },
																				{ "type": "showImage", "name": "shang.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																				{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux", "flag:herotuy2"], "time": 1 },
																				{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy2"] },
																				{ "type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2" },
																			]
																		},
																	]
																},
															],
															"false": [

															]
														},
													]
												},
											],
										},
										{ "type": "showImage" },
										{
											"type": "if", "condition": "flag:linshi1==1",
											"true": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"走路和跳跃，你选一种吧",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"他就在你面前，用什么破技能，丢人",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"无影鬼斩服务部提醒您，您已到站，请下车步行",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"大哥，他就在你面前，跳什么跳",
														{ "type": "exit" },
													],
													"false": [

													]
												},
											],
											"false": [

											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x,core.status.hero.loc.y-core.getFlag('linshi1',100))) {core.setFlag('linshi2',1);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==1",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"我要砍的是怪，懂么？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点没必要用砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"想砍啥呢？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"我的剑，只斩妖魔鬼怪",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x,core.status.hero.loc.y-core.getFlag('linshi1',100)))) {core.setFlag('linshi2',2);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==2",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"等我回去吃几个血瓶回来干翻你",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"想打怪想疯了吧你",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"打怪要讲策略懂么",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"对面那货好像有点硬啊",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点太过危险，请下车",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "setValue", "name": "flag:heroy", "value": "(core.status.hero.loc.y-flag:linshi1)" },
										{ "type": "setValue", "name": "flag:heroy3", "value": "(core.status.hero.loc.y)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)" },
										{
											"type": "if", "condition": "status:experience>=flag:linshi1",
											"true": [
												{ "type": "animate", "name": "wuyingguizhan", "loc": "hero" },
												{ "type": "changePos", "loc": [0, 14] },
												{ "type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaoshang\", \"loc\": [core.getFlag(\"herox\"),core.getFlag(\"heroy3\")]})\n}" },
												{ "type": "changePos", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "animate", "name": "tiaozhansha", "loc": "hero" },
												{ "type": "function", "function": "function(){\ncore.battle(core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\")), core.getFlag(\"herox\"),core.getFlag(\"heroy\"),false)\n}" },
												{ "type": "hide", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "exit" },
											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"剑意不足，拒载",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"待我蓄一波意",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"乡愁是差一点点剑意,我在这头,敌人在那头。",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"太远了有木有",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:heroz==2",
									"true": [
										{ "type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)" },
										{ "type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)" },
										{ "type": "setValue", "name": "flag:panduan", "value": "(flag:herotux)" },
										{ "type": "setValue", "name": "flag:herotux", "value": "(flag:herotux+32)" },
										{ "type": "animateImage", "action": "show", "name": "you.png", "loc": ["flag:herodatux", "flag:herodatuy"], "time": 500 },
										{ "type": "showImage", "name": "you.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
										{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy"] },
										{
											"type": "while", "condition": "true",
											"data": [
												{ "type": "wait" },
												{
													"type": "if", "condition": "flag:type==0",
													"true": [
														{
															"type": "if", "condition": "flag:keycode==27",
															"true": [
																{ "type": "showImage" },
																{ "type": "exit" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==13",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==32",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==39",
															"true": [
																{ "type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux+32)" },
																{ "type": "showImage" },
																{ "type": "showImage", "name": "you.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux2", "flag:herotuy"], "time": 1 },
																{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2", "flag:herotuy"] },
																{ "type": "setValue", "name": "flag:herotux", "value": "flag:herotux2" },
																{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==37",
															"true": [
																{ "type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux-32)" },
																{
																	"type": "if", "condition": "flag:herotux2<=flag:panduan",
																	"true": [
																		{ "type": "setValue", "name": "flag:herotux2", "value": "flag:herotux" },
																	],
																	"false": [
																		{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)" },
																		{ "type": "showImage" },
																		{ "type": "showImage", "name": "you.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																		{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux2", "flag:herotuy"], "time": 1 },
																		{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2", "flag:herotuy"] },
																		{ "type": "setValue", "name": "flag:herotux", "value": "flag:herotux2" },
																	]
																},
															],
															"false": [

															]
														},
													],
													"false": [
														{
															"type": "if", "condition": "flag:y==flag:heroy",
															"true": [
																{ "type": "setValue", "name": "flag:herotux2", "value": "(flag:x*32)" },
																{
																	"type": "if", "condition": "flag:herotux2<=flag:panduan",
																	"true": [

																	],
																	"false": [
																		{
																			"type": "if", "condition": "flag:herotux2==flag:herotux",
																			"true": [
																				{ "type": "showImage" },
																				{ "type": "break" },
																			],
																			"false": [
																				{ "type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.getFlag(\"x\")-core.status.hero.loc.x)\n}" },
																				{ "type": "showImage" },
																				{ "type": "showImage", "name": "you.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																				{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux2", "flag:herotuy"], "time": 1 },
																				{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2", "flag:herotuy"] },
																				{ "type": "setValue", "name": "flag:herotux", "value": "flag:herotux2" },
																			]
																		},
																	]
																},
															],
															"false": [

															]
														},
													]
												},
											],
										},
										{ "type": "showImage" },
										{
											"type": "if", "condition": "flag:linshi1==1",
											"true": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"走和跳，你选一种吧",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"他就在你面前，用什么破技能，丢人",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"无影鬼斩服务部提醒您，您已到站，请下车步行",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"大哥，他就在你面前，跳什么跳",
														{ "type": "exit" },
													],
													"false": [

													]
												},
											],
											"false": [

											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x+core.getFlag('linshi1',100),core.status.hero.loc.y)) {core.setFlag('linshi2',1);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==1",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"我要砍的是怪，懂么？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点没必要用砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"想砍啥呢？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"我的剑，只斩妖魔鬼怪",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x+core.getFlag('linshi1',100),core.status.hero.loc.y))) {core.setFlag('linshi2',2);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==2",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"等我回去吃几个血瓶回来干翻你",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"不是不打，时候未到",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"打怪要讲策略懂么",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"对面那货好像有点硬啊",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点太过危险，请下车",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "setValue", "name": "flag:herox", "value": "(core.status.hero.loc.x+flag:linshi1)" },
										{ "type": "setValue", "name": "flag:herox3", "value": "(core.status.hero.loc.x)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)" },
										{
											"type": "if", "condition": "status:experience>=flag:linshi1",
											"true": [
												{ "type": "animate", "name": "wuyingguizhan", "loc": "hero" },
												{ "type": "changePos", "loc": [0, 14] },
												{ "type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaoyou\", \"loc\": [core.getFlag(\"herox3\"),core.getFlag(\"heroy\")]})\n}" },
												{ "type": "changePos", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "function", "function": "function(){\ncore.battle(core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\")), core.getFlag(\"herox\"),core.getFlag(\"heroy\"),false)\n}" },
												{ "type": "hide", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "exit" },
											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"剑意不足，拒载",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"待我蓄一波意",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"乡愁是差一点点剑意,我在这头,敌人在那头。",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"太远了有木有",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:heroz==3",
									"true": [
										{ "type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)" },
										{ "type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)" },
										{ "type": "setValue", "name": "flag:panduan", "value": "(flag:herotuy)" },
										{ "type": "setValue", "name": "flag:herotuy", "value": "(flag:herotuy+32)" },
										{ "type": "animateImage", "action": "show", "name": "xia.png", "loc": ["flag:herodatux", "flag:herodatuy"], "time": 500 },
										{ "type": "showImage", "name": "xia.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
										{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy"] },
										{
											"type": "while", "condition": "true",
											"data": [
												{ "type": "wait" },
												{
													"type": "if", "condition": "flag:type==0",
													"true": [
														{
															"type": "if", "condition": "flag:keycode==27",
															"true": [
																{ "type": "showImage" },
																{ "type": "exit" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==13",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==32",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==40",
															"true": [
																{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy+32)" },
																{ "type": "showImage" },
																{ "type": "showImage", "name": "xia.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux", "flag:herotuy2"], "time": 1 },
																{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy2"] },
																{ "type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2" },
																{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==38",
															"true": [
																{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy-32)" },
																{
																	"type": "if", "condition": "flag:herotuy2<=flag:panduan",
																	"true": [
																		{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:herotuy+32)" },
																	],
																	"false": [
																		{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)" },
																		{ "type": "showImage" },
																		{ "type": "showImage", "name": "xia.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																		{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux", "flag:herotuy2"], "time": 1 },
																		{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy2"] },
																		{ "type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2" },
																	]
																},
															],
															"false": [

															]
														},
													],
													"false": [
														{
															"type": "if", "condition": "flag:x==flag:herox",
															"true": [
																{ "type": "setValue", "name": "flag:herotuy2", "value": "(flag:y*32)" },
																{
																	"type": "if", "condition": "flag:herotuy2<=flag:panduan",
																	"true": [

																	],
																	"false": [
																		{
																			"type": "if", "condition": "flag:herotuy2==flag:herotuy",
																			"true": [
																				{ "type": "break" },
																			],
																			"false": [
																				{ "type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.getFlag(\"y\")-core.status.hero.loc.y)\n}" },
																				{ "type": "showImage" },
																				{ "type": "showImage", "name": "xia.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																				{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux", "flag:herotuy2"], "time": 1 },
																				{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy2"] },
																				{ "type": "setValue", "name": "flag:herotuy", "value": "flag:herotuy2" },
																			]
																		},
																	]
																},
															],
															"false": [

															]
														},
													]
												},
											],
										},
										{ "type": "showImage" },
										{
											"type": "if", "condition": "flag:linshi1==1",
											"true": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"走和跳，你选一种吧",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"他就在你面前，用什么破技能，丢人",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"无影鬼斩服务部提醒您，您已到站，请下车步行",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"大哥，他就在你面前，跳什么跳",
														{ "type": "exit" },
													],
													"false": [

													]
												},
											],
											"false": [

											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x,core.status.hero.loc.y+core.getFlag('linshi1',100))) {core.setFlag('linshi2',1);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2>=1",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"我要砍的是怪，懂么？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点没必要用砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"想砍啥呢？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"我的剑，只斩妖魔鬼怪",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x,core.status.hero.loc.y+core.getFlag('linshi1',100)))) {core.setFlag('linshi2',2);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==2",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"等我回去吃几个血瓶回来干翻你",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"不是不打，时候未到",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"打怪要讲策略懂么",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"对面那货好像有点硬啊",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点太过危险，拒载",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "setValue", "name": "flag:heroy", "value": "(core.status.hero.loc.y+flag:linshi1)" },
										{ "type": "setValue", "name": "flag:heroy3", "value": "(core.status.hero.loc.y)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)" },
										{
											"type": "if", "condition": "status:experience>=flag:linshi1",
											"true": [
												{ "type": "animate", "name": "wuyingguizhan", "loc": "hero" },
												{ "type": "changePos", "loc": [0, 14] },
												{ "type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaoxia\", \"loc\": [core.getFlag(\"herox\"),core.getFlag(\"heroy3\")]})\n}" },
												{ "type": "changePos", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "animate", "name": "tiaozhansha", "loc": "hero" },
												{ "type": "function", "function": "function(){\ncore.battle(core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\")), core.getFlag(\"herox\"),core.getFlag(\"heroy\"),false)\n}" },
												{ "type": "hide", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "exit" },
											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"剑意不足，拒载",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"待我蓄一波意",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"乡愁是差一点剑意,我在这头,敌人在那头。",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"太远了有木有",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:heroz==4",
									"true": [
										{ "type": "setValue", "name": "flag:herodatux", "value": "(flag:herotux-576)" },
										{ "type": "setValue", "name": "flag:herodatuy", "value": "(flag:herotuy-448)" },
										{ "type": "setValue", "name": "flag:panduan", "value": "(flag:herotux)" },
										{ "type": "setValue", "name": "flag:herotux", "value": "(flag:herotux-32)" },
										{ "type": "animateImage", "action": "show", "name": "zuo.png", "loc": ["flag:herodatux", "flag:herodatuy"], "time": 500 },
										{ "type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
										{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux", "flag:herotuy"] },
										{
											"type": "while", "condition": "true",
											"data": [
												{ "type": "wait" },
												{
													"type": "if", "condition": "flag:type==0",
													"true": [
														{
															"type": "if", "condition": "flag:keycode==27",
															"true": [
																{ "type": "showImage" },
																{ "type": "exit" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==13",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==32",
															"true": [
																{ "type": "showImage" },
																{ "type": "break" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==37",
															"true": [
																{ "type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux-32)" },
																{ "type": "showImage" },
																{ "type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux2", "flag:herotuy"], "time": 1 },
																{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2", "flag:herotuy"] },
																{ "type": "setValue", "name": "flag:herotux", "value": "flag:herotux2" },
																{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1+1)" },
															],
															"false": [

															]
														},
														{
															"type": "if", "condition": "flag:keycode==39",
															"true": [
																{ "type": "setValue", "name": "flag:herotux2", "value": "(flag:herotux+32)" },
																{
																	"type": "if", "condition": "flag:herotux2>=flag:panduan",
																	"true": [
																		{ "type": "setValue", "name": "flag:herotux2", "value": "flag:herotux" },
																	],
																	"false": [
																		{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-1)" },
																		{ "type": "showImage" },
																		{ "type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																		{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux2", "flag:herotuy"], "time": 1 },
																		{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2", "flag:herotuy"] },
																		{ "type": "setValue", "name": "flag:herotux", "value": "flag:herotux2" },
																	]
																},
															],
															"false": [

															]
														},
													],
													"false": [
														{
															"type": "if", "condition": "flag:y==flag:heroy",
															"true": [
																{ "type": "setValue", "name": "flag:herotux2", "value": "(flag:x*32)" },
																{
																	"type": "if", "condition": "flag:herotux2>=flag:panduan",
																	"true": [

																	],
																	"false": [
																		{
																			"type": "if", "condition": "flag:herotux2==flag:herotux",
																			"true": [
																				{ "type": "break" },
																			],
																			"false": [
																				{ "type": "function", "function": "function(){\ncore.setFlag(\"linshi1\",core.status.hero.loc.x-core.getFlag(\"x\"))\n}" },
																				{ "type": "showImage" },
																				{ "type": "showImage", "name": "zuo.png", "loc": ["flag:herodatux", "flag:herodatuy"] },
																				{ "type": "moveImage", "name": "guangbiao.png", "from": ["flag:herotux", "flag:herotuy"], "to": ["flag:herotux2", "flag:herotuy"], "time": 1 },
																				{ "type": "showImage", "name": "guangbiao.png", "loc": ["flag:herotux2", "flag:herotuy"] },
																				{ "type": "setValue", "name": "flag:herotux", "value": "flag:herotux2" },
																			]
																		},
																	]
																},
															],
															"false": [

															]
														},
													]
												},
											],
										},
										{ "type": "showImage" },
										{
											"type": "if", "condition": "flag:linshi1==1",
											"true": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"走和跳，你选一种吧",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"他就在你面前，用什么破技能，丢人",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"无影鬼斩服务部提醒您，您已到站，请下车步行",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"走一走，迈开腿，一步到位，跳什么跳？闲得慌啊！？",
														{ "type": "exit" },
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"大哥，他就在你面前，跳什么跳",
														{ "type": "exit" },
													],
													"false": [

													]
												},
											],
											"false": [

											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemyExists(core.status.hero.loc.x-core.getFlag('linshi1',100),core.status.hero.loc.y)) {core.setFlag('linshi2',1);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==1",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"我要砍的是怪，懂么？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点没必要用斩的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"本人不斩无名之辈.........简单的说墙啊空地啊什么的我是不砍的",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"想砍啥呢？",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"我的剑，只斩妖魔鬼怪",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "function", "function": "function(){\nif (core.enemys.canBattle(core.getBlockId(core.status.hero.loc.x-core.getFlag('linshi1',100),core.status.hero.loc.y))) {core.setFlag('linshi2',2);}\n}" },
										{
											"type": "if", "condition": "flag:linshi2==2",
											"true": [

											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"等我回去吃几个血瓶回来干翻你",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"不是不打，时候未到",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"打怪要讲策略懂么",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"对面那货好像有点硬啊",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"无影鬼斩服务部提醒您，您的目标地点太过危险，拒载",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
										{ "type": "setValue", "name": "flag:herox", "value": "(core.status.hero.loc.x-flag:linshi1)" },
										{ "type": "setValue", "name": "flag:herox3", "value": "(core.status.hero.loc.x)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1-2)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "Math.pow(2, flag:linshi1)" },
										{ "type": "setValue", "name": "flag:linshi1", "value": "(flag:linshi1*20)" },
										{
											"type": "if", "condition": "status:experience>=flag:linshi1",
											"true": [
												{ "type": "animate", "name": "wuyingguizhan", "loc": "hero" },
												{ "type": "changePos", "loc": [0, 14] },
												{ "type": "function", "function": "function(){\ncore.insertAction({\"type\": \"animate\", \"name\": \"qitiaozuo\", \"loc\": [core.getFlag(\"herox3\"),core.getFlag(\"heroy\")]})\n}" },
												{ "type": "changePos", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "animate", "name": "tiaozhansha", "loc": "hero" },
												{ "type": "function", "function": "function(){\ncore.battle(core.getBlockId(core.getFlag(\"herox\"),core.getFlag(\"heroy\")), core.getFlag(\"herox\"),core.getFlag(\"heroy\"),false)\n}" },
												{ "type": "hide", "loc": ["flag:herox", "flag:heroy"] },
												{ "type": "exit" },
											],
											"false": [
												{
													"type": "if", "condition": "flag:suiji==1",
													"true": [
														"无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==2",
													"true": [
														"剑意不足，拒载",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==3",
													"true": [
														"等我蓄一波意",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==4",
													"true": [
														"乡愁是差一点剑意,我在这头,敌人在那头。",
													],
													"false": [

													]
												},
												{
													"type": "if", "condition": "flag:suiji==5",
													"true": [
														"太远了有木有",
													],
													"false": [

													]
												},
												{ "type": "exit" },
											]
										},
									],
									"false": [

									]
								},
							],
							"false": [
								{
									"type": "if", "condition": "flag:suiji==1",
									"true": [
										"无影鬼斩服务部提示您，您的剑意余额已不足，请充值",
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:suiji==2",
									"true": [
										"剑意不足，拒载",
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:suiji==3",
									"true": [
										"待我蓄一波意",
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:suiji==4",
									"true": [
										"乡愁是差一点剑意,我在这头,敌人在那头。",
									],
									"false": [

									]
								},
								{
									"type": "if", "condition": "flag:suiji==5",
									"true": [
										"太远了有木有",
									],
									"false": [

									]
								},
								{ "type": "exit" },
							]
						},
					]

					);

				}

				this.shuoming = function (shuoming) {
					core.insertAction([
						{ "type": "showImage", "name": "jianjian1.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "showImage", "name": "jianjian2.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "showImage", "name": "jianjian3.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "exit" },

					])
				}
				this.shuomingmingling = function (shuoming) {
					core.insertAction([
						{ "type": "showImage", "name": "mingling1.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "showImage", "name": "mingling2.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "showImage", "name": "mingling3.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "exit" },


					])
				}
				this.shuomingmaoguan = function (shuoming) {
					core.insertAction([
						{ "type": "showImage", "name": "maoguan1.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "showImage", "name": "maoguan2.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "showImage", "name": "maoguan3.jpg", "loc": [0, 0] },
						{ "type": "wait" },
						{ "type": "showImage" },
						{ "type": "exit" },

					])
				}
				// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
			}
		}
	}